/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\u0005"}, d2={"instantOfEpochMicro", "Ljava/time/Instant;", "epochMicro", "", "toEpochMicro", "jitsi-utils"})
public final class InstantKt {
    public static final long toEpochMicro(@NotNull Instant $this$toEpochMicro) {
        Intrinsics.checkNotNullParameter($this$toEpochMicro, "<this>");
        if ($this$toEpochMicro.getEpochSecond() < 0L && $this$toEpochMicro.getNano() > 0) {
            long millis = Math.multiplyExact($this$toEpochMicro.getEpochSecond() + 1L, 1000000);
            long adjustment = $this$toEpochMicro.getNano() / 1000 - 1;
            return Math.addExact(millis, adjustment);
        }
        long millis = Math.multiplyExact($this$toEpochMicro.getEpochSecond(), 1000000);
        return Math.addExact(millis, (long)($this$toEpochMicro.getNano() / 1000));
    }

    @NotNull
    public static final Instant instantOfEpochMicro(long epochMicro) {
        long secs = Math.floorDiv(epochMicro, 1000000);
        long mos = Math.floorMod(epochMicro, 1000000);
        Instant instant = Instant.ofEpochSecond(secs, mos * (long)1000);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(...)");
        return instant;
    }
}

