/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public final class TlsBlockCipher
implements TlsCipher {
    private final TlsCryptoParameters cryptoParams;
    private final byte[] randomData;
    private final boolean encryptThenMAC;
    private final boolean useExplicitIV;
    private final boolean acceptExtraPadding;
    private final boolean useExtraPadding;
    private final TlsBlockCipherImpl decryptCipher;
    private final TlsBlockCipherImpl encryptCipher;
    private final TlsSuiteMac readMac;
    private final TlsSuiteMac writeMac;
    private final byte[] decryptConnectionID;
    private final byte[] encryptConnectionID;
    private final boolean decryptUseInnerPlaintext;
    private final boolean encryptUseInnerPlaintext;

    public TlsBlockCipher(TlsCryptoParameters tlsCryptoParameters, TlsBlockCipherImpl tlsBlockCipherImpl, TlsBlockCipherImpl tlsBlockCipherImpl2, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2, int n) throws IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl3;
        TlsBlockCipherImpl tlsBlockCipherImpl4;
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.decryptConnectionID = securityParameters.getConnectionIDPeer();
        this.encryptConnectionID = securityParameters.getConnectionIDLocal();
        this.decryptUseInnerPlaintext = !Arrays.isNullOrEmpty(this.decryptConnectionID);
        this.encryptUseInnerPlaintext = !Arrays.isNullOrEmpty(this.encryptConnectionID);
        this.cryptoParams = tlsCryptoParameters;
        this.randomData = tlsCryptoParameters.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = securityParameters.isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(protocolVersion);
        this.acceptExtraPadding = !protocolVersion.isSSL();
        this.useExtraPadding = securityParameters.isExtendedPadding() && ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion) && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = tlsBlockCipherImpl;
        this.decryptCipher = tlsBlockCipherImpl2;
        if (tlsCryptoParameters.isServer()) {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl2;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl;
        } else {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl2;
        }
        int n2 = 2 * n + tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        if (!this.useExplicitIV) {
            n2 += tlsBlockCipherImpl4.getBlockSize() + tlsBlockCipherImpl3.getBlockSize();
        }
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n2);
        int n3 = 0;
        tlsHMAC.setKey(byArray, n3, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n3 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        tlsBlockCipherImpl4.setKey(byArray, n3 += tlsHMAC2.getMacLength(), n);
        tlsBlockCipherImpl3.setKey(byArray, n3 += n, n);
        n3 += n;
        int n4 = tlsBlockCipherImpl4.getBlockSize();
        int n5 = tlsBlockCipherImpl3.getBlockSize();
        if (this.useExplicitIV) {
            tlsBlockCipherImpl4.init(new byte[n4], 0, n4);
            tlsBlockCipherImpl3.init(new byte[n5], 0, n5);
        } else {
            tlsBlockCipherImpl4.init(byArray, n3, n4);
            tlsBlockCipherImpl3.init(byArray, n3 += n4, n5);
            n3 += n5;
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int n) {
        int n2 = this.decryptCipher.getBlockSize();
        int n3 = this.readMac.getSize();
        int n4 = 256;
        int n5 = n + (this.decryptUseInnerPlaintext ? 1 : 0);
        return this.getCiphertextLength(n2, n3, n4, n5);
    }

    @Override
    public int getCiphertextEncodeLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = this.useExtraPadding ? 256 : n2;
        int n5 = n + (this.encryptUseInnerPlaintext ? 1 : 0);
        return this.getCiphertextLength(n2, n3, n4, n5);
    }

    @Override
    public int getPlaintextDecodeLimit(int n) {
        int n2 = this.decryptCipher.getBlockSize();
        int n3 = this.readMac.getSize();
        int n4 = this.getPlaintextLength(n2, n3, n);
        return n4 - (this.decryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = this.getPlaintextLength(n2, n3, n);
        return n4 - (this.encryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long l, short s2, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = this.encryptCipher.getBlockSize();
        int n7 = this.writeMac.getSize();
        int n8 = n5 = n3 + (this.encryptUseInnerPlaintext ? 1 : 0);
        if (!this.encryptThenMAC) {
            n8 += n7;
        }
        int n9 = n6 - n8 % n6;
        if (this.useExtraPadding) {
            n4 = (256 - n9) / n6;
            int n10 = this.chooseExtraPadBlocks(n4);
            n9 += n10 * n6;
        }
        n4 = n5 + n7 + n9;
        if (this.useExplicitIV) {
            n4 += n6;
        }
        byte[] byArray2 = new byte[n + n4];
        int n11 = n;
        if (this.useExplicitIV) {
            byte[] byArray3 = this.cryptoParams.getNonceGenerator().generateNonce(n6);
            System.arraycopy(byArray3, 0, byArray2, n11, n6);
            n11 += n6;
        }
        int n12 = n11;
        System.arraycopy(byArray, n2, byArray2, n11, n3);
        n11 += n3;
        short s3 = s2;
        if (this.encryptUseInnerPlaintext) {
            byArray2[n11++] = (byte)s2;
            s3 = 25;
        }
        if (!this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(l, s3, this.encryptConnectionID, byArray2, n12, n5);
            System.arraycopy(byArray4, 0, byArray2, n11, byArray4.length);
            n11 += byArray4.length;
        }
        byte by = (byte)(n9 - 1);
        for (int i = 0; i < n9; ++i) {
            byArray2[n11++] = by;
        }
        this.encryptCipher.doFinal(byArray2, n, n11 - n, byArray2, n);
        if (this.encryptThenMAC) {
            byte[] byArray5 = this.writeMac.calculateMac(l, s3, this.encryptConnectionID, byArray2, n, n11 - n);
            System.arraycopy(byArray5, 0, byArray2, n11, byArray5.length);
            n11 += byArray5.length;
        }
        if (n11 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray2, 0, byArray2.length, s3);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long l, short s2, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        short s3;
        block9: {
            byte by;
            byte[] byArray2;
            boolean bl;
            int n4 = this.decryptCipher.getBlockSize();
            int n5 = this.readMac.getSize();
            int n6 = n4;
            n6 = this.encryptThenMAC ? (n6 += n5) : Math.max(n6, n5 + 1);
            if (this.useExplicitIV) {
                n6 += n4;
            }
            if (n2 < n6) {
                throw new TlsFatalAlert(50);
            }
            int n7 = n2;
            if (this.encryptThenMAC) {
                n7 -= n5;
            }
            if (n7 % n4 != 0) {
                throw new TlsFatalAlert(21);
            }
            if (this.encryptThenMAC && !(bl = TlsUtils.constantTimeAreEqual(n5, byArray2 = this.readMac.calculateMac(l, s2, this.decryptConnectionID, byArray, n, n2 - n5), 0, byArray, n + n2 - n5))) {
                throw new TlsFatalAlert(20);
            }
            this.decryptCipher.doFinal(byArray, n, n7, byArray, n);
            if (this.useExplicitIV) {
                n += n4;
                n7 -= n4;
            }
            int n8 = this.checkPaddingConstantTime(byArray, n, n7, n4, this.encryptThenMAC ? 0 : n5);
            bl = n8 == 0;
            int n9 = n7 - n8;
            if (!this.encryptThenMAC) {
                byte[] byArray3 = this.readMac.calculateMacConstantTime(l, s2, this.decryptConnectionID, byArray, n, n9 -= n5, n7 - n5, this.randomData);
                bl |= !TlsUtils.constantTimeAreEqual(n5, byArray3, 0, byArray, n + n9);
            }
            if (bl) {
                throw new TlsFatalAlert(20);
            }
            s3 = s2;
            n3 = n9;
            if (!this.decryptUseInnerPlaintext) break block9;
            do {
                if (--n3 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = byArray[n + n3]));
            s3 = (short)(by & 0xFF);
        }
        return new TlsDecodeResult(byArray, n, n3, s3);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.decryptUseInnerPlaintext;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.encryptUseInnerPlaintext;
    }

    private int checkPaddingConstantTime(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        byte by = byArray[n5 - 1];
        int n6 = by & 0xFF;
        int n7 = n6 + 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = Math.min(this.acceptExtraPadding ? 256 : n3, n2 - n4);
        if (n7 > n10) {
            n7 = 0;
        } else {
            int n11 = n5 - n7;
            do {
                n9 = (byte)(n9 | byArray[n11++] ^ by);
            } while (n11 < n5);
            n8 = n7;
            if (n9 != 0) {
                n7 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n8 < 256) {
            n9 = (byte)(n9 | byArray2[n8++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n9);
        return n7;
    }

    private int chooseExtraPadBlocks(int n) {
        byte[] byArray = this.cryptoParams.getNonceGenerator().generateNonce(4);
        int n2 = Pack.littleEndianToInt(byArray, 0);
        int n3 = Integers.numberOfTrailingZeros(n2);
        return Math.min(n3, n);
    }

    private int getCiphertextLength(int n, int n2, int n3, int n4) {
        int n5 = n4;
        if (this.useExplicitIV) {
            n5 += n;
        }
        n5 += n3;
        if (this.encryptThenMAC) {
            n5 -= n5 % n;
            n5 += n2;
        } else {
            n5 += n2;
            n5 -= n5 % n;
        }
        return n5;
    }

    private int getPlaintextLength(int n, int n2, int n3) {
        int n4 = n3;
        if (this.encryptThenMAC) {
            n4 -= n2;
            n4 -= n4 % n;
        } else {
            n4 -= n4 % n;
            n4 -= n2;
        }
        --n4;
        if (this.useExplicitIV) {
            n4 -= n;
        }
        return n4;
    }
}

