/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.CapitalizeFirstStream;
import org.armedbear.lisp.CapitalizeStream;
import org.armedbear.lisp.DowncaseStream;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.UpcaseStream;

public abstract class CaseFrobStream
extends Stream {
    protected final Stream target;
    private static final Primitive MAKE_CASE_FROB_STREAM = new Primitive("make-case-frob-stream", Lisp.PACKAGE_SYS, false, "target kind"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Stream target = Lisp.checkCharacterOutputStream(first);
            if (second == Keyword.UPCASE) {
                return new UpcaseStream(target);
            }
            if (second == Keyword.DOWNCASE) {
                return new DowncaseStream(target);
            }
            if (second == Keyword.CAPITALIZE) {
                return new CapitalizeStream(target);
            }
            if (second == Keyword.CAPITALIZE_FIRST) {
                return new CapitalizeFirstStream(target);
            }
            return Lisp.error(new TypeError("Kind must be :UPCASE, :DOWNCASE, :CAPITALIZE or :CAPITALIZE-FIRST."));
        }
    };

    protected CaseFrobStream(Stream target) {
        super(Symbol.CASE_FROB_STREAM);
        this.target = target;
    }

    @Override
    public LispObject getElementType() {
        return this.target.getElementType();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.CASE_FROB_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.CASE_FROB_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.CASE_FROB_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.CASE_FROB_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public boolean isInputStream() {
        return false;
    }

    @Override
    public boolean isOutputStream() {
        return true;
    }

    @Override
    public boolean isCharacterInputStream() {
        return false;
    }

    @Override
    public boolean isBinaryInputStream() {
        return false;
    }

    @Override
    public boolean isCharacterOutputStream() {
        return true;
    }

    @Override
    public boolean isBinaryOutputStream() {
        return false;
    }

    @Override
    public int getCharPos() {
        return this.target.getCharPos();
    }

    @Override
    public void setCharPos(int n) {
        this.target.setCharPos(n);
    }

    @Override
    protected int _readChar() {
        this.notSupported();
        return -1;
    }

    @Override
    protected void _unreadChar(int n) {
        this.notSupported();
    }

    @Override
    protected boolean _charReady() {
        this.notSupported();
        return false;
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        this._writeString(new String(chars, start, end));
    }

    @Override
    public int _readByte() {
        this.notSupported();
        return -1;
    }

    @Override
    public void _writeByte(int n) {
        this.notSupported();
    }

    @Override
    public void _finishOutput() {
        this.target._finishOutput();
    }

    @Override
    public void _clearInput() {
        this.notSupported();
    }

    @Override
    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    @Override
    public LispObject listen() {
        this.notSupported();
        return Lisp.NIL;
    }

    @Override
    public LispObject terpri() {
        return this.target.terpri();
    }

    @Override
    public LispObject freshLine() {
        return this.target.freshLine();
    }

    @Override
    public String printObject() {
        return this.unreadableString("CASE-FROB-STREAM");
    }

    private void notSupported() {
        Lisp.error(new TypeError("Operation is not supported for streams of type CASE-FROB-STREAM."));
    }
}

